// $Id: CRegistryInfo.cpp,v 1.5 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CRegistryInfo.hpp"
using Exponent::Host::CRegistryInfo;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CRegistryInfo, CCountedObject);

//	===========================================================================
CRegistryInfo::CRegistryInfo(const CString &name, const CString &value)
			 : m_keyName(name)
			 , m_keyValue(value)
{
	EXPONENT_CLASS_CONSTRUCTION(CRegistryInfo);
}

//	===========================================================================
CRegistryInfo::~CRegistryInfo()
{
	EXPONENT_CLASS_DESTRUCTION(CRegistryInfo);
}

//	===========================================================================
void CRegistryInfo::setName(const CString &name) 
{ 
	m_keyName = name;
}

//	===========================================================================
void CRegistryInfo::setValue(const CString &value) 
{ 
	m_keyValue = value; 
}

//	===========================================================================
const CString &CRegistryInfo::getName() const 
{
	return m_keyName;
}

//	===========================================================================
const CString &CRegistryInfo::getValue() const 
{
	return m_keyValue;
}